import es, wcs, random, playerlib
from wcs import wcs
#Register Item syntax: registerItem(name, section, cost, fire, function)
#Different Sections for menus: enhancement, powerup, attack, defense, special
''' |==============================================================|
	|                    Acceptable Fire Commands:                 |
	|==============================================================|
	| onbuy                                                        | 
	|   - Runs when the item is bought                             |
	|															   |
	| onetime                                                      |
	|   - Makes the item only run once, does not effect the user's |
	|     maxitem count and only triggers the onbuy fire           |
	|															   |
	| spawn 	 												   |
	|   - Runs when a player spawns                                |
	|															   |
	| pickup 													   |
	|   - Runs when the user picks up an item                      |
	|															   |
	| userhurt 													   |
	|   - Runs when the user hits/gets hit                         |
	|															   |
	| attackerhurt                                                 |
	|   - Runs when a user hits someone                            |
	|															   |
	| userdeath                                                    |
	|   - Runs when the user dies and when they kill someone       |
	|     														   |
	| attackerdeath                                                |
	|   - Runs when you kill someone                               |
	|                                                              |
	| flash                                                        |
	|   - Runs when the player is hit by a flashbang               |
	|==============================================================|
'''
def load():
	shop = wcs.ShopMenu()
	'''
 	|=========================================================================================================================|
	|shop.registeritem('Name of item',  |      'item type',   |cost,  | ('fire commands'), |                       function)  |
	|===================================|=====================|=======|====================|==================================|'''
	shop.registerItem('Cloak of Shadows',		'enhancement',	2000,	('onbuy','pickup'),						CloakLevel1)
	shop.registerItem('Boots of Speed',			'enhancement',	3500,	('onbuy','spawn'),						BootsofSpeed)
	shop.registerItem('Claws of Attack',		'attack',	  	2500,	('onbuy','attackerhurt','userdeath'),	ClawsofAttack)
	shop.registerItem('Orb of Frost',			'attack',	  	3000,	('attackerhurt'),						OrbofFrost)
	shop.registerItem('Ring of Regeneration',	'defense',	  	4000,	('onbuy','userhurt'),					RingofRegeneration)
	shop.registerItem('Goggles of the Sun',		'defense',	  	2000,	('flash'),								GogglesoftheSun)
	shop.registerItem('Potion of Healing',		'special',	  	800, 	('onbuy','onetime'),					PotionofHealing)
	shop.registerItem('Tome of Xp',				'special',	  	5000,	('onbuy','onetime'),					TombofXp)
	shop.registerItem('Periapt of Health',		'powerup',	  	6000,	('onbuy','onetime'),					PeriaptofHealth)
	shop.registerItem('Tome of Health',			'powerup',	  	4500,	('onbuy','spawn'),						TomeofHealth)
	#Thank you Kevin For:
	shop.registerItem('Sock of the Feather',    'enhancement',  2500,   ('onbuy','spawn'),                      SockofFeather)
	#Thank you bonbon for:
	#shop.registerItem('Ahkn Of Reincarnation',  'special',      2000,   ('onbuy','spawn', 'pickup'),            giveweapons)
''' shop.registerItem('Name of the item',		'item type',    cost,	('Firing commands',						Callback Function)
    |==========================================================================================================================|
	|=================================================== END OF ITEM REGISTERING ==============================================|
	|==========================================================================================================================|
	
		|==========================|
		| Values Passes into Item  | 
		|  Methods based on type:  |
		|==========================|
		|**************************|
		|==========================|
		| spawn, onbuy, and pickup:|
		|==========================|
		|                          |
		| Userid                   |
		| Userteam                 |
		|                          |
		|==========================|
		| hurt and death:          |
		|==========================|
		|                          |
		| userid                   |
		| userteam                 |  
		| attacker                 |
		| attackerteam             |
		|                          |
		|--                        |
		|                          |
		| Hurt also passes the     |
		| damage dealt in: damage  |
		|                          |
		|==========================|
		|**************************|
		|==========================|
'''
player_info = {}
def giveweapons(values):
	global player_info
	pistols = ('glock', 'p228', 'elite', 'deagle', 'usp', 'fiveseven')
	userid = values['userid']
	get = playerlib.getPlayer(userid).get
	if values['type'] == 'onbuy':
		player_info[userid] = {}
		player_info[userid]['primary'] = get('primary')
		player_info[userid]['secondary'] = get('secondary')
	elif values['type'] == 'spawn':
		if player_info.has_key(userid):
			es.server.cmd('es_xgive %s %s'%(userid, player_info[userid]['primary']))
			es.server.cmd('es_xgive %s %s'%(userid, player_info[userid]['secondary']))
			del player_info[userid]
	elif values['type'] == 'pickup':
		if values['weapon'] in pistols:
			player_info[userid]['secondary'] = 'weapon_%s'%values['weapon']
		else:
			player_info[userid]['primary'] = 'weapon_%s'%values['weapon']
def SockofFeather(values):
	#lower users Gravity to 50%
	wcs.Command(values['userid']).SetGravity(0.5)
def GogglesoftheSun(values):
	# This reduces the flash effect from flashbangs
	playerUser = playerlib.getPlayer(values['userid'])
	playerUser.set('flash',[playerUser.get('flashalpha')/2,playerUser.get('flashduration')/2])
	
def RingofRegeneration(values):
	# Starts the regen, 1 gain per 1 second
	wcs.Command(values['userid']).Regen(1,1)
	
def OrbofFrost(values):
	# Runs whenever the player attacks another
	# Gives the user around a 1 in 6 chance of freezing the enemy
	if not random.randrange(6):
		wcs.Command(values['userid']).Freeze(4)
		
def TombofXp(values):
	# Adds 100 xp to the users race
	wcs.Command(values['userid']).GiveXp(100)
	
def TomeofHealth(values):
	# Adds 50 Health to the users maximum health
	wcs.Command(values['userid']).HealthAdd(50)
	
def PeriaptofHealth(values):
	# Adds 100 health to the users maximum health
	wcs.Command(values['userid']).HealthAdd(100)
	
def PotionofHealing(values):
	# Heals the user a random amount between 12 and 27 hp
	heal_amount = random.randint(12,27)
	wcs.Command(values['userid']).Heal(heal_amount)
	es.tell(values['userid'],'#multi','#greenPotion of Healing #default- #lightgreenThe potion restored %s hit points'%heal_amount)
	
def CloakLevel1(values):
	# Make the user's alpha 60% of his usuall
	player = wcs.Command(values['userid'])
	if values['type'] == 'onbuy':
		alpha = player.ReturnDict('Alpha')
		player.Fade(alpha*0.6,2)
		player.UpdateDict('Cloak Alpha',alpha*0.6)
	elif values['type'] == 'pickup':
		player.Color(alpha=player.ReturnDict('Cloak Alpha'))
	
def BootsofSpeed(values):
	# Adds 10% speed to the user
	wcs.Command(values['userid']).SpeedAdd(0.1)
	
def ClawsofAttack(values):
	if values['type'] == 'onbuy':
		userKey = wcs.Command(values['userid']).ReturnUserKey()
		if userKey.has_key('damage percent bonus'):
			userKey['damage percent bonus'] += .06
		else:
			userKey['damage percent bonus'] = .06
	elif values['type'] == 'hurt':
		#es.msg('WCSDebug: Running Claws Hurt for %s bonus damage'%values['damage']*wcs.Command(values['attacker']).ReturnDict('damage percent bonus'))
		wcs.Command(values['userid']).Damage(values['damage']*wcs.Command(values['attacker']).ReturnDict('damage percent bonus'),32,values['attacker'])
	elif values['type'] == 'userdeath':
		wcs.Command(values['userid']).UpdateDict('damage percent bonus',0.0)
