# ./addons/eventscripts/serverclock/serverclock.py

import es
import gamethread
from time import strftime
from usermsg import hudhint

def clock():
    if es.getplayercount():
        for x in es.getUseridList():
            hudhint(x, 'ServerClock: %s' % strftime('%H:%M:%S'))
        gamethread.delayedname(1, 'serverclock', clock)

def round_start(ev):
    clock()

def round_end(ev):
    gamethread.cancelDelayed('serverclock')

def player_disconnect(ev):
    def checkDead():
        if not es.getplayercount():
            gamethread.cancelDelayed('serverclock')
    gamethread.delayed(2, checkDead)

def load():
    es.ServerVar('serverclock_ver', 1, "BackRaw's ServerClock").makepublic()
    clock()

def unload():
    gamethread.cancelDelayed('serverclock')